/*
 * fixed_p.h
 *
 *  Created on: May 26, 2020
 *      Author: tp
 */

#ifndef FIXED_P_H_
#define FIXED_P_H_

#include <stdio.h>

#define QBITS 				16
#define QBITS_D2			8
#if QBITS_D2 != (QBITS/2)
#error "Error defining QBITS and QBITS_D2"
#endif



typedef int Fixed;


#define FIXED_ONE			(1 << QBITS)
#define INT2FIXED(x)		((Fixed)((int)(x) << QBITS))
#define FIXED2INT(x)		((x) >> QBITS)
#define FLOAT2FIXED(x)		((int)((x)*(1 << QBITS)))
#define FIXED2FLOAT(x)		(((float)(x))/(1 << QBITS))
#define FIXED_MUL(x,y)		Fix_Mul((x),(y))
#define FIXED_MUL_H(x,y)	Fix_Mulh((x),(y))
#define FIXED_DIV(n,d)		Fix_Div((n),(d))



typedef uint32_t Fixedu;

#define QBITS 				16
#define QBITS_D2			8
#if QBITS_D2 != (QBITS/2)
#error "Error defining QBITS and QBITS_D2"
#endif
#define FIXEDU_ONE			(1 << QBITS)
#define INT2FIXEDU(x)		((Fixedu)((uint32_t)(x) << QBITS))
#define FIXEDU2INT(x)		((x) >> QBITS)
#define FLOAT2FIXEDU(x)		((uint32_t)((x)*(1 << QBITS)))
#define FIXEDU2FLOAT(x)		(((float)(x))/(1 << QBITS))
#define FIXEDU_MUL(x,y)		Fix_Mul((x),(y))
#define FIXEDU_MUL_H(x,y)	Fix_Mulh((x),(y))
#define FIXEDU_DIV(n,d)		Fix_Div((n),(d))


#if QBITS == 16

//#pragma GCC push_option
//#pragma GCC optimize("-O3")
static inline Fixedu Fix_Div (Fixedu Num, Fixedu Den){
	uint64_t NumL;
	/* shift again to reach full precision */
	NumL = ((uint64_t)Num) << QBITS;
	NumL = NumL / ((uint64_t)Den);
	return (Fixedu)(NumL);
}

#define Fix_Mul(x,y) (((x) >> QBITS_D2)*((y) >> QBITS_D2))
static inline Fixedu Fix_Mulh(Fixedu x, Fixedu y){
	uint64_t NumL;
	NumL = ((uint64_t)x) * ((uint64_t)y);
	NumL =  NumL >> QBITS;
	return (Fixedu)(NumL);
}






//#pragma GCC pop_option

#elif QBITS == 8
#pragma GCC push_option
#pragma GCC optimize("-O3")
static inline Fixed Fix_Div (Fixed Num, Fixed Den){
	/* shift again to reach full precision */
	Num = Num << QBITS;
	return (Fixed)(Num / Den);
}
#pragma GCC pop_option

#define Fix_Mul(x,y) ((x*y) >> QBITS))

#else
#error "function not defined"
#endif




#endif /* FIXED_P_H_ */
